<?php
include 'common-foxi.php';
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if (isset($_GET['s'])) {
	if ($_GET['s'] == "gamelistv1") {
		try {
			$url = $GLOBALS['ApiUrl'] . "/api/gamelist";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 10,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'GET'
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = $httpCode;
				$response->msg = 'code ' . $httpCode;
				$response->data = $data;
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "gamelist") {
		try {
			$postData = array('provider' => 'PG', 'operator_token' => $GLOBALS['tokenKey'], 'agent_api_key' => $GLOBALS['key']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/v2/getGameList";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 10,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = $httpCode;
				$response->msg = 'code ' . $httpCode;
				$response->data = $data;
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "play") {
		try {
			$postData = array('player_name' => $_POST['username'], 'game_code' => $_POST['gameCode'], 'provider' => 'PG', 'operator_token' => $GLOBALS['tokenKey'], 'agent_api_key' => $GLOBALS['key']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/v2/playGame";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = $httpCode;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "getUserCredit") {
		try {
			$postData = array('player_name' => $_POST['username'], 'operator_token' => $GLOBALS['tokenKey'], 'agent_api_key' => $GLOBALS['key']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/v2/getPlayerWallet";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = $httpCode;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "setPasswordUser") {
		try {
			$postData = array('username' => $GLOBALS['agent'] . $_POST['member_username'], 'password' => $_POST['member_password'], 'agent_api_key' => $GLOBALS['key']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/changepassword";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = 500;
				$response->msg = 'code ' . $httpCode;
				$response->data = $data;
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "transferCreditTo") {
		if ($_POST['amount'] < 0) {
			$response = new stdClass();
			$response->code = 1000;
			$response->msg = 'amount more 1';
			echo json_encode($response);
			exit;
		}
		if ($_POST['amount'] == 0) {
			$response = new stdClass();
			$response->code = 1000;
			$response->msg = 'amount more 0';
			echo json_encode($response);
			exit;
		}
		try {
			$postData = array('player_name' => $_POST['username'], 'amount' => $_POST['amount'], 'transfer_type' => 'deposit', 'transfer_reference' => $_POST['transfer_reference'], 'operator_token' => $GLOBALS['tokenKey'], 'agent_api_key' => $GLOBALS['key']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/v2/transferBalance";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = $httpCode;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "TransferCreditOut") {
		if ($_POST['amount'] <= 0) {
			$response = new stdClass();
			$response->code = 1000;
			$response->msg = 'amount less 1';
			echo json_encode($response);
			exit;
		}
		if ($_POST['amount'] == 0) {
			$response = new stdClass();
			$response->code = 1000;
			$response->msg = 'amount not 0';
			echo json_encode($response);
			exit;
		}

		try {
			$postData = array('player_name' => $_POST['username'], 'amount' => $_POST['amount'], 'transfer_type' => 'withdraw', 'transfer_reference' => $_POST['transfer_reference'], 'operator_token' => $GLOBALS['tokenKey'], 'agent_api_key' => $GLOBALS['key']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/v2/transferBalance";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = $httpCode;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "TransferCreditAllOut") {
		try {
			$postData = array('player_name' => $_POST['username'], 'transfer_type' => 'allout', 'transfer_reference' => $_POST['transfer_reference'], 'operator_token' => $GLOBALS['tokenKey'], 'agent_api_key' => $GLOBALS['key']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/v2/transferBalance";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = $httpCode;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "turnover") {
		try {
			$start = date("Y-m-d 00:00:00");
			if (isset($_POST['start_date'])) {
				$start = $_POST['start_date'];
			}

			$end = date("Y-m-d H:i:s");
			if (isset($_POST['end_date'])) {
				$end = $_POST['end_date'];
			}

			$postData = array('username' => $GLOBALS['agent'] . $_POST['member_username'], 'start_date' => $start, 'end_date' => $end, 'agent_api_key' => $GLOBALS['key'], 'agent_user' => $GLOBALS['agent']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/turnover";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = $httpCode;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "income") {
		try {
			$start = date("Y-m-d 00:00:00");
			if (isset($_POST['start_date'])) {
				$start = $_POST['start_date'];
			}

			$end = date("Y-m-d H:i:s");
			if (isset($_POST['end_date'])) {
				$end = $_POST['end_date'];
			}

			$postData = array('username' => $GLOBALS['agent'] . $_POST['member_username'], 'start_date' => $start, 'end_date' => $end, 'agent_api_key' => $GLOBALS['key'], 'agent_user' => $GLOBALS['agent']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/income";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = $httpCode;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "history") {
		try {
			$start = date("Y-m-d 00:00:00");
			if (isset($_POST['start_date'])) {
				$start = $_POST['start_date'];
			}

			$end = date("Y-m-d H:i:s");
			if (isset($_POST['end_date'])) {
				$end = $_POST['end_date'];
			}

			$postData = array('username' => $GLOBALS['agent'] . $_POST['member_username'], 'start_date' => $start, 'end_date' => $end, 'agent_api_key' => $GLOBALS['key'], 'agent_user' => $GLOBALS['agent']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/history";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = 500;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "history_with_turnover") {
		try {
			$start = date("Y-m-d 00:00:00");
			if (isset($_POST['start_date'])) {
				$start = $_POST['start_date'];
			}

			$end = date("Y-m-d H:i:s");
			if (isset($_POST['end_date'])) {
				$end = $_POST['end_date'];
			}

			$postData = array('username' => $GLOBALS['agent'] . $_POST['member_username'], 'start_date' => $start, 'end_date' => $end, 'agent_api_key' => $GLOBALS['key'], 'agent_user' => $GLOBALS['agent']);
			$postData = http_build_query($postData);

			$url = $GLOBALS['ApiUrl'] . "/api/history_with_turnover";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = 500;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else if ($_GET['s'] == "history_with_turnover_with_winloss") {
		try {
			$start = date("Y-m-d 00:00:00");
			if (isset($_POST['start_date'])) {
				$start = $_POST['start_date'];
			}

			$end = date("Y-m-d H:i:s");
			if (isset($_POST['end_date'])) {
				$end = $_POST['end_date'];
			}

			$postData = array('username' => $GLOBALS['agent'] . $_POST['member_username'], 'start_date' => $start, 'end_date' => $end, 'agent_api_key' => $GLOBALS['key'], 'agent_user' => $GLOBALS['agent']);
			$postData = http_build_query($postData);
			
// 			echo $postData;
// 			exit;

			$url = $GLOBALS['ApiUrl'] . "/api/history_with_turnover_with_winloss";

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => $postData
			));
			$data = curl_exec($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);
			$result = json_decode($data, true);
			$response = new stdClass();

			if ($httpCode == 200) {
				echo $data;
			} else {
				$response->code = 500;
				$response->msg = 'code ' . $httpCode;
				$response->data = $result['msg'];
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$response = new stdClass();
			$response->code = 500;
			$response->msg = $e->getMessage();
			echo json_encode($response);
		}
	} else {
		$response = new stdClass();
		$response->code = 500;
		$response->msg = 'input s not found';
		echo json_encode($response);
	}
} else {
	$response = new stdClass();
	$response->code = 500;
	$response->msg = 'please input type';
	echo json_encode($response);
}
